/**
 * \file: mspin_lm_framebuffer_adapter.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin LayerManager FrameBuffer Adapter
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES thilobjoern.fickel@bosch-softtec.com
 *
 * \copyright: (c) 2015 Bosch SoftTec
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_LM_FRAMEBUFFER_ADAPTER_H_
#define MSPIN_LM_FRAMEBUFFER_ADAPTER_H_

#include <mspin_lm_adapter.h>
#include <apx.h>

typedef struct mspin_framebuffer_context mspin_framebuffer_context;

void mspin_framebuffer_initGlobalHandler(void* data, struct wl_registry* registry, uint32_t name,
        const char* interface, uint32_t version);

int mspin_framebuffer_init(mspin_wl_context_t *pWLCtx);

int mspin_framebuffer_createImage(mspin_wl_context_t *pWLCtx, int width, int height);

void mspin_framebuffer_destroyImage(mspin_wl_context_t *pWLCtx);

void mspin_framebuffer_drawImage(mspin_wl_context_t *pWLCtx, int width, int height);

#endif /* MSPIN_LM_FRAMEBUFFER_ADAPTER_H_ */
